IF OBJECT_ID('UFD_EXP_CTB_MOV_RC_CRED_MOEDAS') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_EXP_CTB_MOV_RC_CRED_MOEDAS
	END 
GO	 
 
CREATE FUNCTION UFD_EXP_CTB_MOV_RC_CRED_MOEDAS(@CD_EMP		INT,
									    @CD_FILIAL	INT,
									    @DT_INI		DATETIME,
									    @DT_FIM		DATETIME)		
RETURNS @RS_RETURN TABLE(
			CD_EMP					INT,
			CD_FILIAL				INT, 
			VL_PGTO					MONEY,
			VL_JUR					MONEY,
			VL_DESC					MONEY,
			VLR_GLOSA				MONEY,
			CD_CNT					INT,
			CD_CLI					INT,
			RZ_CLI					VARCHAR(200),
			HIST_LANCTO				VARCHAR(150),
			NR_DP					INT, 
			ANO						INT,
			PARC					INT, 
			CD_RC_DEB				INT,
			NM_FANT					VARCHAR(100),
			DUP_PROV_RECU_GLOSA		INT,
			TP_TRANSACAO			INT,
			DT_PAG					DATETIME,
			CD_CTB_CNT_CARTAO       VARCHAR(50),
			CD_CTB_CNT_CARTAO_RED   INT,
			VLR_IMPOSTO             MONEY,
			CD_CTR                  INT, 
			CD_CX                   INT,
			CD_FILIAL_CUPOM         INT)
AS
BEGIN       

	DECLARE @CD_GRP_ECON			INT
	
	SET @CD_GRP_ECON = (SELECT PRC_GRP_ECON_PRC_FILIAL.CD_GRP_ECON
						FROM PRC_FILIAL
							INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON
								PRC_FILIAL.CD_EMP = PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND 
								PRC_FILIAL.CD_FILIAL = PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL
						WHERE
						    PRC_FILIAL.CD_EMP = @CD_EMP
						    AND PRC_FILIAL.CD_FILIAL = @CD_FILIAL
						    AND PRC_FILIAL.FILIAL_MTZ_GRP_ECON = 1)
	
	IF ISNULL(@CD_GRP_ECON,0) = 0 
		BEGIN
			RETURN
		END
		

	INSERT INTO @RS_RETURN 
		SELECT 
			RC_CRED.CD_EMP,
			RC_CRED.CD_FILIAL, 
			RC_CRED.VL_PGTO,
			RC_CRED.VL_JUR,
			RC_CRED.VL_DESC,
			RC_CRED.VLR_GLOSA,
			BC_LANC.CD_CNT,
			RC_DEB.CD_CLI,
			RC_CLI.RZ_CLI,
			HIST_LANC AS HIST_LANCTO,
			RC_DEB.NR_DP, 
			RC_DEB.ANO,
			RC_DEB.PARC, 
			RC_DEB.CD_RC_DEB,
			PRC_FILIAL.NM_FANT,
			(CASE WHEN ISNULL(RC_CLI_CONV_GLOSA_RC_DEB.NR_DP,0) > 0 THEN 1 ELSE 0 END) AS DUP_PROV_RECU_GLOSA,
			0 AS TP_TRANSACAO,
			RC_CRED.DT_PAG,
			'0' AS CD_CTB_CNT_CARTAO,
			0   AS CD_CTB_CNT_CARTAO_RED,
			ISNULL(RC_CRED.VLR_IMPOSTO,0)VLR_IMPOSTO,
            ISNULL(CUPOM.CD_CTR,0 ) CD_CTR, 
			ISNULL(CUPOM.CD_CX,0)CD_CX,
			ISNULL(CUPOM.CD_FILIAL,0)CD_FILIAL_CUPOM
			 
--ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_DINH,0 ) VLR_DINHEIRO, 
--ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CHQS_A_VISTA,0)VLR_CHQS_A_VISTA ,  
--ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CHQS_A_PRZ,0) VLR_CHQS_A_PRZ, 
--ISNULL(PDV_CUPOM_NAO_FISCAL.VLR_CARTAO,0)VLR_CARTAO

		FROM
			RC_CRED 
			INNER JOIN RC_DEB ON 
				RC_CRED.CD_EMP = RC_DEB.CD_EMP AND 
				RC_CRED.CD_FILIAL = RC_DEB.CD_FILIAL AND
				RC_CRED.CD_RC_DEB = RC_DEB.CD_RC_DEB
				
			INNER JOIN RC_CRED_BC_LANC ON 
				RC_CRED.CD_EMP = RC_CRED_BC_LANC.CD_EMP AND
				RC_CRED.CD_FILIAL = RC_CRED_BC_LANC.CD_FILIAL AND 
				RC_CRED.CD_RC_DEB = RC_CRED_BC_LANC.CD_RC_DEB AND
				RC_CRED.CD_DP_LANC = RC_CRED_BC_LANC.CD_DP_LANC
				
			INNER JOIN BC_LANC ON 
				RC_CRED_BC_LANC.CD_EMP = BC_LANC.CD_EMP AND
				RC_CRED_BC_LANC.CD_BC_LANC = BC_LANC.CD_BC_LANC
			
			INNER JOIN RC_CLI ON 
				RC_DEB.CD_EMP = RC_CLI.CD_EMP AND
				RC_DEB.CD_CLI = RC_CLI.CD_CLI
				
			LEFT OUTER JOIN RC_CLI_CONV_GLOSA_RC_DEB ON
				RC_DEB.CD_EMP = RC_CLI_CONV_GLOSA_RC_DEB.CD_EMP AND 
				RC_DEB.CD_FILIAL = RC_CLI_CONV_GLOSA_RC_DEB.CD_FILIAL AND
				RC_DEB.NR_DP = RC_CLI_CONV_GLOSA_RC_DEB.NR_DP AND
				RC_DEB.ANO = RC_CLI_CONV_GLOSA_RC_DEB.ANO

			INNER JOIN PRC_FILIAL ON
				RC_CRED.CD_EMP = PRC_FILIAL.CD_EMP AND
				RC_CRED.CD_FILIAL = PRC_FILIAL.CD_FILIAL

           	LEFT JOIN RC_PGTO_PDV_RC_CRED AS VINC_CRED   ON  
			RC_CRED.CD_EMP = VINC_CRED.CD_EMP 
			AND RC_CRED.CD_FILIAL = VINC_CRED.CD_FILIAL 
			AND RC_CRED.CD_RC_DEB = VINC_CRED.CD_RC_DEB 
			AND RC_CRED.CD_DP_LANC= VINC_CRED.CD_DP_LANC 
			
			LEFT  JOIN RC_PGTO_PDV ON RC_PGTO_PDV.CD_CTR_PGTO = VINC_CRED.CD_CTR_PGTO 
			LEFT  JOIN PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV VINC ON VINC.CD_CTR_PGTO= RC_PGTO_PDV.CD_CTR_PGTO 
			LEFT JOIN PDV_CUPOM_NAO_FISCAL AS CUPOM  
			ON CUPOM.CD_EMP = VINC.CD_EMP AND CUPOM.CD_FILIAL = VINC.CD_FILIAL AND CUPOM.CD_CTR = VINC.CD_CTR


		WHERE
			RC_CRED.CD_EMP			= @CD_EMP
			AND RC_CRED.CD_FILIAL	IN (SELECT CD_FILIAL 
										FROM PRC_GRP_ECON_PRC_FILIAL
										WHERE CD_GRP_ECON = @CD_GRP_ECON)
			AND RC_CRED.DT_PAG		BETWEEN @DT_INI AND @DT_FIM

		UNION ALL

		SELECT 
			PDV_CUPOM_NAO_FISCAL.CD_EMP,
			PDV_CUPOM_NAO_FISCAL.CD_FILIAL, 
			RC_CRED.VL_PGTO, 
			RC_CRED.VL_JUR, 
			RC_CRED.VL_DESC, 
			0 AS ValorGlosa,
			0 AS CD_CNT, 
			RC_DEB.CD_CLI, 
			RC_CLI.RZ_CLI,
			'RECEBTO DUP. Nº ' + CONVERT(VARCHAR(20),RC_DEB.NR_DP) + ' - ' +  CONVERT(VARCHAR(20),RC_DEB.PARC) + '  FIL.: ' + CONVERT(VARCHAR(20),RC_DEB.CD_FILIAL) + ' - ' + RC_CLI.RZ_CLI AS HIST_LANC,
			RC_DEB.NR_DP, 
			RC_DEB.ANO,
			RC_DEB.PARC, 
			RC_DEB.CD_RC_DEB, 
			PRC_FILIAL.NM_FANT,
			0 AS DUP_PROV_RECU_GLOSA,
			1 AS TP_TRANSACAO,
			RC_CRED.DT_PAG,
			ISNULL(RC_CLI_CNT_CTB.CD_CTB_CNT,'0') CD_CTB_CNT_CARTAO,
			ISNULL(RC_CLI_CNT_CTB.CD_CTB_CNT_RED,0) CD_CTB_CNT_CARTAO_RED,
			ISNULL(RC_CRED.VLR_IMPOSTO,0)VLR_IMPOSTO,
            ISNULL(PDV_CUPOM_NAO_FISCAL.CD_CTR,0 ) CD_CTR, 
			ISNULL(PDV_CUPOM_NAO_FISCAL.CD_CX,0)CD_CX,
			ISNULL(PDV_CUPOM_NAO_FISCAL.CD_FILIAL,0)CD_FILIAL_CUPOM

		FROM 
			PDV_RECBTO_TEF 
			INNER JOIN PDV_CUPOM_NAO_FISCAL_TEF ON 
				PDV_RECBTO_TEF.CD_EMP = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP AND
				PDV_RECBTO_TEF.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL AND
				PDV_RECBTO_TEF.CD_RECTO_TEF = PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF 
			INNER JOIN PDV_CUPOM_NAO_FISCAL ON 
				PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP = PDV_CUPOM_NAO_FISCAL.CD_EMP AND
				PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL = PDV_CUPOM_NAO_FISCAL.CD_FILIAL AND
				PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR = PDV_CUPOM_NAO_FISCAL.CD_CTR 
			INNER JOIN RC_ADM_CARTAO ON 
				PDV_RECBTO_TEF.CD_EMP = RC_ADM_CARTAO.CD_EMP AND
				PDV_RECBTO_TEF.CD_ADM_CARTAO = RC_ADM_CARTAO.CD_ADM_CARTAO
			INNER JOIN RC_ADM_CARTAO_RC_CLI ON 
				PDV_RECBTO_TEF.CD_EMP = RC_ADM_CARTAO_RC_CLI.CD_EMP AND 
				PDV_RECBTO_TEF.CD_ADM_CARTAO = RC_ADM_CARTAO_RC_CLI.CD_ADM_CARTAO 
			INNER JOIN RC_CLI AS RC_CLI_CARTAO ON 
				RC_ADM_CARTAO_RC_CLI.CD_EMP = RC_CLI_CARTAO.CD_EMP AND 
				RC_ADM_CARTAO_RC_CLI.CD_CLI = RC_CLI_CARTAO.CD_CLI	 
			INNER JOIN PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV ON 
				PDV_CUPOM_NAO_FISCAL.CD_EMP = PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP AND
				PDV_CUPOM_NAO_FISCAL.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL AND
				PDV_CUPOM_NAO_FISCAL.CD_CTR = PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR 
			INNER JOIN RC_PGTO_PDV ON 
				PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO = RC_PGTO_PDV.CD_CTR_PGTO 
			INNER JOIN RC_PGTO_PDV_RC_CRED ON 
				RC_PGTO_PDV.CD_CTR_PGTO = RC_PGTO_PDV_RC_CRED.CD_CTR_PGTO 
			INNER JOIN RC_CRED ON 
				RC_PGTO_PDV_RC_CRED.CD_EMP = RC_CRED.CD_EMP AND 
				RC_PGTO_PDV_RC_CRED.CD_FILIAL = RC_CRED.CD_FILIAL AND
				RC_PGTO_PDV_RC_CRED.CD_RC_DEB = RC_CRED.CD_RC_DEB AND 
				RC_PGTO_PDV_RC_CRED.CD_DP_LANC = RC_CRED.CD_DP_LANC 
			INNER JOIN RC_DEB ON 
				RC_CRED.CD_EMP = RC_DEB.CD_EMP AND 
				RC_CRED.CD_FILIAL = RC_DEB.CD_FILIAL AND 
				RC_CRED.CD_RC_DEB = RC_DEB.CD_RC_DEB 
			INNER JOIN RC_CLI ON 
				RC_DEB.CD_EMP = RC_CLI.CD_EMP AND 
				RC_DEB.CD_CLI = RC_CLI.CD_CLI 
			INNER JOIN PRC_FILIAL ON 
				PDV_CUPOM_NAO_FISCAL.CD_EMP = PRC_FILIAL.CD_EMP AND 
				PDV_CUPOM_NAO_FISCAL.CD_FILIAL = PRC_FILIAL.CD_FILIAL
			LEFT OUTER JOIN RC_CRED_BC_LANC ON
				RC_CRED.CD_EMP = RC_CRED_BC_LANC.CD_EMP AND
				RC_CRED.CD_FILIAL = RC_CRED_BC_LANC.CD_FILIAL AND
				RC_CRED.CD_RC_DEB = RC_CRED_BC_LANC.CD_RC_DEB AND
				RC_CRED.CD_DP_LANC = RC_CRED_BC_LANC.CD_DP_LANC
			LEFT JOIN RC_CLI_CNT_CTB ON 
				RC_CLI_CNT_CTB.CD_EMP = RC_CLI_CARTAO.CD_EMP
				AND RC_CLI_CNT_CTB.CD_CLI = RC_CLI_CARTAO.CD_CLI
				AND RC_CLI_CNT_CTB.TP_CNT_CTB = 0 

		WHERE
			PDV_CUPOM_NAO_FISCAL.CD_EMP			= @CD_EMP 
			AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL  IN (SELECT CD_FILIAL 
													FROM PRC_GRP_ECON_PRC_FILIAL
													WHERE CD_GRP_ECON = @CD_GRP_ECON)
			AND RC_CRED.DT_PAG					BETWEEN @DT_INI AND @DT_FIM 
			AND RC_CRED_BC_LANC.CD_DP_LANC IS NULL 

		--UNION ALL 

		--SELECT
		--	PDV_CUPOM_NAO_FISCAL.CD_EMP,
		--	PDV_CUPOM_NAO_FISCAL.CD_FILIAL,
		--	RC_CREDIARIO_PARC_CRED.VLR_CRED,
		--	0 AS VL_JUR,
		--	0 AS VL_DESC,
		--	0 AS VALORGLOSA,
		--	0 AS CD_CNT,
		--	RC_CLI.CD_CLI,
		--	RC_CLI.RZ_CLI,
		--	'RECEBTO PARCELA. Nº ' + CONVERT(VARCHAR(20), RC_CREDIARIO_PARC.CD_CTR) + ' - ' + CONVERT(VARCHAR(20), RC_CREDIARIO_PARC.PARC_CRED) + ' - ' + RC_CLI.RZ_CLI AS HIST_LANC,    
		--	RC_CREDIARIO_PARC.CD_CTR,
		--	0 AS ANO,
		--	RC_CREDIARIO_PARC.PARC_CRED,
		--	0 AS CD_RC_DEB,
		--	PRC_FILIAL.NM_FANT,
		--	0 AS DUP_PROV_RECU_GLOSA,
		--	1 AS TP_TRANSACAO,
		--	PDV_CUPOM_NAO_FISCAL.DT_CUPOM,
		--	ISNULL(RC_CLI_CNT_CTB.CD_CTB_CNT,'0') CD_CTB_CNT_CARTAO,
		--	ISNULL(RC_CLI_CNT_CTB.CD_CTB_CNT_RED,0) CD_CTB_CNT_CARTAO_RED,
		--	0 AS VLR_IMPOSTO,
  --          ISNULL(PDV_CUPOM_NAO_FISCAL.CD_CTR,0 ) CD_CTR, 
		--	ISNULL(PDV_CUPOM_NAO_FISCAL.CD_CX,0)CD_CX,
		--	ISNULL(PDV_CUPOM_NAO_FISCAL.CD_FILIAL,0)CD_FILIAL_CUPOM  

 
		--FROM
		--	RC_CREDIARIO_PARC 
		--	INNER JOIN RC_CLI ON
		--		RC_CREDIARIO_PARC.CD_EMP = RC_CLI.CD_EMP AND
		--		RC_CREDIARIO_PARC.CD_CLI = RC_CLI.CD_CLI
		--	INNER JOIN PRC_FILIAL
		--	INNER JOIN PDV_RECBTO_TEF
		--	INNER JOIN PDV_CUPOM_NAO_FISCAL_TEF ON
		--		PDV_RECBTO_TEF.CD_EMP = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP AND
		--		PDV_RECBTO_TEF.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL AND
		--		PDV_RECBTO_TEF.CD_RECTO_TEF = PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF
		--	INNER JOIN PDV_CUPOM_NAO_FISCAL ON
		--		PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP = PDV_CUPOM_NAO_FISCAL.CD_EMP AND
		--		PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL = PDV_CUPOM_NAO_FISCAL.CD_FILIAL AND
		--		PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR = PDV_CUPOM_NAO_FISCAL.CD_CTR
		--	INNER JOIN RC_ADM_CARTAO ON
		--		PDV_RECBTO_TEF.CD_EMP = RC_ADM_CARTAO.CD_EMP AND
		--		PDV_RECBTO_TEF.CD_ADM_CARTAO = RC_ADM_CARTAO.CD_ADM_CARTAO
		--	INNER JOIN RC_ADM_CARTAO_RC_CLI ON 
		--		PDV_RECBTO_TEF.CD_EMP = RC_ADM_CARTAO_RC_CLI.CD_EMP AND 
		--		PDV_RECBTO_TEF.CD_ADM_CARTAO = RC_ADM_CARTAO_RC_CLI.CD_ADM_CARTAO 
		--	INNER JOIN RC_CLI AS RC_CLI_CARTAO ON 
		--		RC_ADM_CARTAO_RC_CLI.CD_EMP = RC_CLI_CARTAO.CD_EMP AND 
		--		RC_ADM_CARTAO_RC_CLI.CD_CLI = RC_CLI_CARTAO.CD_CLI
		--	INNER JOIN PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV ON
		--		PDV_CUPOM_NAO_FISCAL.CD_EMP = PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP AND
		--		PDV_CUPOM_NAO_FISCAL.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL AND
		--		PDV_CUPOM_NAO_FISCAL.CD_CTR = PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR
		--	INNER JOIN RC_PGTO_PDV ON
		--		PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO = RC_PGTO_PDV.CD_CTR_PGTO ON
		--		PRC_FILIAL.CD_EMP = PDV_CUPOM_NAO_FISCAL.CD_EMP AND
		--		PRC_FILIAL.CD_FILIAL = PDV_CUPOM_NAO_FISCAL.CD_FILIAL INNER JOIN
		--		RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED ON
		--		RC_PGTO_PDV.CD_CTR_PGTO = RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED.CD_CTR_PGTO
		--	INNER JOIN RC_CREDIARIO_PARC_CRED ON
		--		RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED.CD_CTR = RC_CREDIARIO_PARC_CRED.CD_CTR AND
		--		RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED.CD_CTR_CRED = RC_CREDIARIO_PARC_CRED.CD_CTR_CRED ON
		--		RC_CREDIARIO_PARC.CD_CTR = RC_CREDIARIO_PARC_CRED.CD_CTR
		--	LEFT JOIN RC_CLI_CNT_CTB ON 
		--		RC_CLI_CNT_CTB.CD_EMP = RC_CLI_CARTAO.CD_EMP
		--		AND RC_CLI_CNT_CTB.CD_CLI = RC_CLI_CARTAO.CD_CLI
		--		AND RC_CLI_CNT_CTB.TP_CNT_CTB = 0 

		--WHERE
		--	PDV_CUPOM_NAO_FISCAL.CD_EMP			=  @CD_EMP
		--	AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL  IN (SELECT CD_FILIAL 
		--											FROM PRC_GRP_ECON_PRC_FILIAL
		--											WHERE CD_GRP_ECON = @CD_GRP_ECON)
		--	AND PDV_CUPOM_NAO_FISCAL.DT_CUPOM   BETWEEN @DT_INI AND @DT_FIM 

        UNION ALL 


		SELECT
			PDV_CUPOM_NAO_FISCAL.CD_EMP,
			PDV_CUPOM_NAO_FISCAL.CD_FILIAL,
			RC_CREDIARIO_PARC_CRED.VLR_CRED,
			0 AS VL_JUR,
			0 AS VL_DESC,
			0 AS VALORGLOSA,
			0 AS CD_CNT,
			RC_CLI.CD_CLI,
			RC_CLI.RZ_CLI,
			'ANTECIPAÇÃO DE COMPRA ' + CONVERT(VARCHAR(20), RC_CREDIARIO_PARC.CD_CTR) + ' - ' + CONVERT(VARCHAR(20), RC_CREDIARIO_PARC.PARC_CRED) + ' - ' + RC_CLI.RZ_CLI AS HIST_LANC,    
			RC_CREDIARIO_PARC.CD_CTR,
			0 AS ANO,
			RC_CREDIARIO_PARC.PARC_CRED,
			0 AS CD_RC_DEB,
			PRC_FILIAL.NM_FANT,
			0 AS DUP_PROV_RECU_GLOSA,
			1 AS TP_TRANSACAO,
			PDV_CUPOM_NAO_FISCAL.DT_CUPOM,
			'0'   AS CD_CTB_CNT_CARTAO,
			0     AS CD_CTB_CNT_CARTAO_RED,
			0     AS VLR_IMPOSTO,
            ISNULL(PDV_CUPOM_NAO_FISCAL.CD_CTR,0 ) CD_CTR, 
			ISNULL(PDV_CUPOM_NAO_FISCAL.CD_CX,0)CD_CX,
			ISNULL(PDV_CUPOM_NAO_FISCAL.CD_FILIAL,0)CD_FILIAL_CUPOM  
          
		FROM                             
			RC_CREDIARIO_PARC_CRED INNER JOIN  RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED ON                             
			RC_CREDIARIO_PARC_CRED.CD_CTR =  RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED.CD_CTR AND                             
			RC_CREDIARIO_PARC_CRED.CD_CTR_CRED =  RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED.CD_CTR_CRED                             
			INNER JOIN  RC_CREDIARIO_PARC ON                             
			RC_CREDIARIO_PARC_CRED.CD_CTR =  RC_CREDIARIO_PARC.CD_CTR                             
			INNER JOIN  RC_CLI ON                             
			RC_CREDIARIO_PARC.CD_EMP =  RC_CLI.CD_EMP AND                             
			RC_CREDIARIO_PARC.CD_CLI =  RC_CLI.CD_CLI                             
			INNER JOIN  GLB_CID ON                             
			RC_CLI.CD_CID =  GLB_CID.CD_CID                             
			LEFT OUTER JOIN  RC_CLI_CREDIARIO ON                             
			RC_CLI.CD_EMP =  RC_CLI_CREDIARIO.CD_EMP AND                             
			RC_CLI.CD_CLI =  RC_CLI_CREDIARIO.CD_CLI                             
			INNER JOIN  RC_PGTO_PDV ON                             
			RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED.CD_CTR_PGTO =  RC_PGTO_PDV.CD_CTR_PGTO                             
			INNER JOIN  PDV_CUPOM_NAO_FISCAL                             
			INNER JOIN  PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV ON                             
			PDV_CUPOM_NAO_FISCAL.CD_EMP =  PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP AND                             
			PDV_CUPOM_NAO_FISCAL.CD_FILIAL =  PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL AND                             
			PDV_CUPOM_NAO_FISCAL.CD_CTR =  PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR ON                             
			RC_PGTO_PDV.CD_CTR_PGTO =  PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO                             
			LEFT OUTER JOIN  RC_MOT_BLOQ_CLI ON                             
			RC_CLI_CREDIARIO.CD_MOT_BLOQ_CLI =  RC_MOT_BLOQ_CLI.CD_MOT_BLOQ_CLI                             
			INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON                             
			PDV_CUPOM_NAO_FISCAL.CD_EMP = PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND                             
			PDV_CUPOM_NAO_FISCAL.CD_FILIAL = PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL                             
			INNER JOIN PRC_GRP_ECON ON                             
			PRC_GRP_ECON_PRC_FILIAL.CD_GRP_ECON = PRC_GRP_ECON.CD_GRP_ECON 
			INNER JOIN PRC_FILIAL on 
			PRC_FILIAL.CD_EMP = PDV_CUPOM_NAO_FISCAL.CD_EMP
			AND  PRC_FILIAL.CD_FILIAL = PDV_CUPOM_NAO_FISCAL.CD_FILIAL                          
			LEFT JOIN GLB_REG ON                             
			GLB_REG.CD_EMP = RC_CLI.CD_EMP AND                              
			GLB_REG.CD_REG=RC_CLI.CD_REGI 
				LEFT JOIN RC_CLI_CNT_CTB ON 
				RC_CLI_CNT_CTB.CD_EMP = RC_CLI.CD_EMP
				AND RC_CLI_CNT_CTB.CD_CLI = RC_CLI.CD_CLI
				AND RC_CLI_CNT_CTB.TP_CNT_CTB = 0                             
        
		WHERE                              
			PDV_CUPOM_NAO_FISCAL.CD_EMP	 =  @CD_EMP
			AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL  IN (SELECT CD_FILIAL 
													FROM PRC_GRP_ECON_PRC_FILIAL
													WHERE CD_GRP_ECON = @CD_GRP_ECON)
			AND PDV_CUPOM_NAO_FISCAL.DT_CUPOM   BETWEEN @DT_INI AND @DT_FIM 
		   AND PDV_CUPOM_NAO_FISCAL.ST_CUPOM <> 3 

		ORDER BY DT_PAG,CD_CLI, NR_DP, ANO, PARC, CD_CNT, HIST_LANCTO
		
	RETURN
		
END		